#pragma once

#include <list>
#include <map>
#include <string>
#include "Office.h"
#include "Employee.h"

using namespace std;

class Company
{
private:
	list<Office> offices;
	map<int, Employee> employees;

public:
	Company();
	~Company();

	void AddOffice(Office o);
	void RemoveOffice(const string &city, const string &country);
	void DisplayOffices() const;

	void DisplayEmployee(int id) ;
	void AddEmployee(Employee e, int id);
	bool AlreadyExists(int id) const;
	void GivePayrise(int id, double amount);
};